﻿using HIPS.PcehrDataStore.Schemas;
using HIPS.Web.UI.ViewModels.AssistedRegistration;

namespace HIPS.Web.UI.Conversion.AssistedRegistration
{
    public static class UnregisteredPatientViewModelExtensions
    {
        public static UnregisteredPatientViewModel LoadFromPatientWithoutPcehr(this UnregisteredPatientViewModel viewModel, PatientWithoutPcehr patient)
        {
            viewModel.FamilyName = patient.RegisteredFamilyName;
            viewModel.GivenNames = patient.RegisteredGivenName;
            viewModel.Ihi = patient.Ihi;
            viewModel.DateOfBirth = patient.DateOfBirth;
            viewModel.HospitalCode = patient.HospitalCode;
            viewModel.Ward = patient.Ward;
            viewModel.Room = patient.Room;
            viewModel.Bed = patient.Bed;

            return viewModel;
        }
    }
}